local kids, JudgmentSet
local player = Var "Player"
local pn = ToEnumShortString(player)

-- - - - - - - - - - - - - - - - - - - - - -

local TNSFrames = {
	TapNoteScore_W1 = 0,
	TapNoteScore_W2 = 1,
	TapNoteScore_W3 = 2,
	TapNoteScore_W4 = 3,
	TapNoteScore_W5 = 4,
	TapNoteScore_Miss = 5
}


local t = Def.ActorFrame {
	Name="Player Judgment"
}


t.InitCommand=function(self)
	kids = self:GetChildren()
	JudgmentSet = kids.JudgmentWithOffsets
end
t.JudgmentMessageCommand=function(self, param)
	if param.Player ~= player then return end
	if not param.TapNoteScore then return end
	if param.HoldNoteScore then return end

	-- frame check; actually relevant now.
	local iNumStates = JudgmentSet:GetNumStates()
	local frame = TNSFrames[ param.TapNoteScore ]
	if not frame then return end
	if iNumStates == 12 then
		frame = frame * 2
		if not param.Early then
			frame = frame + 1
		end
	end
	self:playcommand("Reset")

	-- begin commands
	JudgmentSet:visible( true )
	JudgmentSet:setstate( frame )

	-- frame0 is like (-fantastic)
	-- frame1 is like (fantastic-)
	if frame == 0 or frame == 1 then
		JudgmentSet:zoom(0.80)
	else
		JudgmentSet:zoom(0.85)
	end

	JudgmentSet:decelerate(0.1):zoom(0.75):sleep(1)
	JudgmentSet:accelerate(0.2):zoom(0)
end

t[#t+1] = Def.Sprite{
	Name="JudgmentWithOffsets",
	InitCommand=function(self)
		self:pause():visible(false)
		self:Load( THEME:GetPathG("", "Miso") )
	end,
	ResetCommand=cmd(finishtweening; stopeffect; visible,false)
}


return t